/* 
 *  GetSessionCodesRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.CodeListI;
import com.avaya.ccs.api.enums.CodeType;
import com.avaya.ccs.javafxrefclient.Logger;
import com.avaya.ccs.javafxrefclient.UserDataGUI;

import javafx.concurrent.WorkerStateEvent;

public class GetSessionCodesRequest extends SessionRequest {

    private static final Logger LOG = Logger.getLogger(GetSessionCodesRequest.class);
    private final CodeType typeRequested;
    private final UserDataGUI gui;

    public GetSessionCodesRequest(UserDataGUI gui, CodeType typeRequested) {
        super(LOG);
        this.gui = gui;
        this.typeRequested = typeRequested;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        CodeListI codes = null;
        switch (typeRequested) {
        case ACW:
            codes = getSession().getAfterCallWorkCodes();
            break;
        case NRRC:
            codes = getSession().getNotReadyReasonCodes();
            break;
        default:
            break;
        }
        LOG.trace(methodName + "-");
        return codes;
    }

    @Override
    public void setSucceeded() {
        this.setOnSucceeded((WorkerStateEvent t) -> {
            String methodName = "succeededHandler() ";
            CodeListI value = (CodeListI) t.getSource().valueProperty().getValue();
            if (value != null) {
                LOG.debug(methodName + "CodeListI:" + value);
                gui.updateCodeSectionForm(value);
            } else {
                LOG.debug(methodName + " NULL");
            }
        });
    }
}
